/*
 * Decompiled with CFR 0.152.
 */
package qouteall.imm_ptl.core.portal;

import com.mojang.logging.LogUtils;
import net.minecraft.class_2499;
import org.jetbrains.annotations.Nullable;
import org.slf4j.Logger;
import qouteall.q_misc_util.my_util.Mesh2D;

public class GeometryPortalShape {
    private static final Logger LOGGER = LogUtils.getLogger();
    public static final int MAX_TRIANGLE_NUM = 10000;

    @Nullable
    public static Mesh2D readOldMeshFromTag(class_2499 tag) {
        int size = tag.size();
        if (size % 6 != 0) {
            LOGGER.error("Invalid Portal Shape Data {}", (Object)tag);
            return null;
        }
        Mesh2D mesh = new Mesh2D();
        int triangleNum = size / 6;
        triangleNum = Math.min(triangleNum, 10000);
        for (int i = 0; i < triangleNum; ++i) {
            mesh.addTriangle(tag.method_10611(i * 6 + 0), tag.method_10611(i * 6 + 1), tag.method_10611(i * 6 + 2), tag.method_10611(i * 6 + 3), tag.method_10611(i * 6 + 4), tag.method_10611(i * 6 + 5));
        }
        if (mesh.getStoredTriangleNum() == 0) {
            return null;
        }
        return mesh;
    }

    @Nullable
    public static Mesh2D readOldMeshFromTagNonNormalized(class_2499 tag, double halfWidth, double halfHeight) {
        int size = tag.size();
        if (size % 6 != 0) {
            LOGGER.error("Invalid Portal Shape Data {}", (Object)tag);
            return null;
        }
        Mesh2D mesh = new Mesh2D();
        int triangleNum = size / 6;
        triangleNum = Math.min(triangleNum, 10000);
        for (int i = 0; i < triangleNum; ++i) {
            mesh.addTriangle(tag.method_10611(i * 6 + 0) / halfWidth, tag.method_10611(i * 6 + 1) / halfHeight, tag.method_10611(i * 6 + 2) / halfWidth, tag.method_10611(i * 6 + 3) / halfHeight, tag.method_10611(i * 6 + 4) / halfWidth, tag.method_10611(i * 6 + 5) / halfHeight);
        }
        if (mesh.getStoredTriangleNum() == 0) {
            return null;
        }
        return mesh;
    }
}

